<?php

namespace Database\Seeders;

use App\Models\Currency;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class CurrencyTableSeeder extends Seeder
{
	/**
	 * Run the database seeds.
	 *
	 * @return void
	 */

	public function run()
	{
		Model::unguard();

		DB::table('currencies')->delete();

		DB::statement('ALTER TABLE currencies AUTO_INCREMENT = 1');

		$newCurrency = new Currency();
		$newCurrency->name = 'Dollar';
		$newCurrency->code = 'USD';
		$newCurrency->symbol = '$';
		$newCurrency->position = 'front';
		$newCurrency->is_deletable = false;
		$newCurrency->save();

		$rupeeCurrency = new Currency();
		$rupeeCurrency->name = 'Rupee';
		$rupeeCurrency->code = 'INR';
		$rupeeCurrency->symbol = '₹';
		$rupeeCurrency->position = 'front';
		$rupeeCurrency->is_deletable = false;
		$rupeeCurrency->save();
	}
}
